#include <iostream>
#include <set>
#include <unordered_map>
#include <vector>

using namespace std;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n, q, mode, x;
    cin >> n >> q;

    vector<int> a(n);
    unordered_map<int, long long> cards;
    cards.reserve(n + q);
    set<pair<long long, int>> values;
    long long gsum = 0;

    for (int i = 0; i < n; i++) {
        cin >> x;
        a[i] = x;
        auto &card = cards[x];
        if (card != 0) gsum -= card;
        auto old = values.find({card, x});
        card += x;
        gsum += card;

        if (old != values.end()) {
            auto node = values.extract(old);
            node.value().first = card;
            values.insert(std::move(node));
        } else {
            values.insert({card, x});
        }
    }

    for (int i = 0; i < q; i++) {
        cin >> mode >> x;
        if (mode == 1) {
            auto size = (long long)values.size();
            long long j = 0, stop = size - n + x;

            if (stop <= 0) {
                cout << 0 << '\n';
                continue;
            }

            if (stop >= size) {
                cout << gsum << '\n';
                continue;
            }

            if (stop > size / 2) {
                long long remove = 0;
                auto it = values.rbegin();
                for (int k = 0; k < size - stop; k++) {
                    remove += it->first;
                    it++;
                }

                cout << (gsum - remove) << '\n';
            } else {
                long long sum = 0;
                auto it = values.begin();
                for (int k = 0; k < stop; k++) {
                    sum += it->first;
                    it++;
                }

                cout << sum << '\n';
            }
        } else {
            auto &y = a[x - 1];
            auto old = y;
            cin >> y;

            if (old == y) continue;
            gsum += y - old;
            auto &old_card = cards[old];
            auto it_old = values.find({old_card, old});
            old_card -= old;

            if (old_card == 0) {
                values.erase(it_old);
            } else {
                auto node = values.extract(it_old);
                node.value().first = old_card;
                values.insert(std::move(node));
            }

            auto &card = cards[y];
            auto it = values.find({card, y});
            card += y;
            if (it != values.end()) {
                auto node = values.extract(it);
                node.value().first = card;
                values.insert(std::move(node));
            } else {
                values.insert({card, y});
            }
        }
    }

    return 0;
}